/***************************************************************************
                            spu.c  -  description
                             -------------------
    begin                : Sun Jan 12 2003
    copyright            : (C) 2003 by Pete Bernert
    email                : BlackDove@addcom.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/
              
//*************************************************************************//
// History of changes:
//
// 2003/03/01 - Pete
// - added mono mode
//
// 2003/01/12 - Pete
// - added recording funcs (win version only)
//
//*************************************************************************//

#include <windows.h>
#include <mmsystem.h>
#include "record.h"

////////////////////////////////////////////////////////////////////////

HMMIO    hWaveFile=NULL;
MMCKINFO mmckMain;
MMCKINFO mmckData;

////////////////////////////////////////////////////////////////////////

void RecordStart( char *szFileName, int rate, int bits, int channels )
{
 WAVEFORMATEX pcmwf;

 // setup header in the same format as our directsound stream
 memset(&pcmwf,0,sizeof(WAVEFORMATEX));
 pcmwf.wFormatTag      = WAVE_FORMAT_PCM;

 if( channels == 1 )
  {
   pcmwf.nChannels       = 1;
   pcmwf.nBlockAlign     = 2;
  }
 else
  {
   pcmwf.nChannels       = 2;
   pcmwf.nBlockAlign     = 4;
  }

 pcmwf.nSamplesPerSec  = rate;
 pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
 pcmwf.wBitsPerSample  = bits;

 // create file
 hWaveFile=mmioOpen(szFileName,NULL,MMIO_CREATE|MMIO_WRITE|MMIO_EXCLUSIVE | MMIO_ALLOCBUF);
 if(!hWaveFile) return;
 
 // setup WAVE, fmt and data chunks
 memset(&mmckMain,0,sizeof(MMCKINFO));
 mmckMain.fccType = mmioFOURCC('W','A','V','E');

 mmioCreateChunk(hWaveFile,&mmckMain,MMIO_CREATERIFF);

 memset(&mmckData,0,sizeof(MMCKINFO));
 mmckData.ckid    = mmioFOURCC('f','m','t',' ');
 mmckData.cksize  = sizeof(WAVEFORMATEX);

 mmioCreateChunk(hWaveFile,&mmckData,0);
 mmioWrite(hWaveFile,(char*)&pcmwf,sizeof(WAVEFORMATEX)); 
 mmioAscend(hWaveFile,&mmckData,0);

 mmckData.ckid = mmioFOURCC('d','a','t','a');
 mmioCreateChunk(hWaveFile,&mmckData,0);
}

////////////////////////////////////////////////////////////////////////

void RecordStop()
{
 // first some check, if recording is running
 if(!hWaveFile) return;

 // now finish writing & close the wave file
 mmioAscend(hWaveFile,&mmckData,0);
 mmioAscend(hWaveFile,&mmckMain,0);
 mmioClose(hWaveFile,0);

 // init var
 hWaveFile=NULL;
}

////////////////////////////////////////////////////////////////////////

void RecordBuffer(unsigned char* pSound,long lBytes)
{
 // write the samples
 if(hWaveFile)
	 mmioWrite(hWaveFile, (const char *) pSound,lBytes);
}
